@echo off
rem ------------------------------------------------------------
rem scan_security_en.bat
rem Recursively scan *.exe and *.dll under current folder.
rem Output CSV: File,ASLR,DEP,CFG,SafeSEH,GS,Notes
rem ------------------------------------------------------------

chcp 936 >nul
setlocal

set "OUT=%~dp0ScanResult.csv"
set "TMP=%~dp0__dump.tmp"
set "TMPERR=%~dp0__dump.err"

rem --- Keywords (English + Chinese variations for compatibility) ---
set "KW_ASLR=Dynamic base 动态基址"
set "KW_DEP=NX compatible NX兼容 NX 可执行"
set "KW_CFG=Guard CF 控制流保护"
set "KW_SEH=SafeSEH Safe Exception Handlers 安全异常处理"
set "KW_GS=/GS"

rem --- Remove old output ---
if exist "%OUT%" del "%OUT%" >nul 2>&1

rem --- Ensure dumpbin is available ---
where dumpbin >nul 2>&1
if errorlevel 1 (
    echo dumpbin not found in PATH, trying to load Visual Studio vcvars64.bat...
    if exist "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\Community\VC\Auxiliary\Build\vcvars64.bat" (
        call "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\Community\VC\Auxiliary\Build\vcvars64.bat" >nul 2>&1
    ) else if exist "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\Professional\VC\Auxiliary\Build\vcvars64.bat" (
        call "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\Professional\VC\Auxiliary\Build\vcvars64.bat" >nul 2>&1
    ) else if exist "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\BuildTools\VC\Auxiliary\Build\vcvars64.bat" (
        call "%ProgramFiles(x86)%\Microsoft Visual Studio\2022\BuildTools\VC\Auxiliary\Build\vcvars64.bat" >nul 2>&1
    ) else (
        echo Warning: Could not locate vcvars64.bat. Please run this script from "x64 Native Tools Command Prompt".
    )
)

where dumpbin >nul 2>&1
if errorlevel 1 (
    echo ERROR: dumpbin not found. Press any key to exit...
    pause >nul
    exit /b 1
)

rem --- Write CSV header ---
echo "File","ASLR","DEP","CFG","SafeSEH","GS","Notes" > "%OUT%"

rem --- Enumerate exe/dll files (safe for brackets/whitespace paths) ---
for /f "delims=" %%F in ('dir /b /s *.exe *.dll 2^>nul') do call :process "%%~fF"

echo.
echo Scan complete.
echo Result file: %OUT%
echo.
pause
endlocal
exit /b 0

rem ===========================================================
:process <fullpath>
rem Subroutine: process a single file and append to CSV
setlocal enabledelayedexpansion
set "file=%~1"
set "aslr=No"
set "dep=No"
set "cfg=No"
set "seh=No"
set "gs=No"
set "notes="

if exist "%TMP%" del "%TMP%" >nul 2>&1
if exist "%TMPERR%" del "%TMPERR%" >nul 2>&1

rem --- Check PE headers ---
dumpbin /headers "%file%" > "%TMP%" 2> "%TMPERR%"
set "rc=%ERRORLEVEL%"

if "%rc%" neq "0" (
    set "notes=ERROR: dumpbin /headers failed"
) else (
    for %%k in (%KW_ASLR%) do findstr /I /C:"%%k" "%TMP%" >nul && set "aslr=Yes"
    for %%k in (%KW_DEP%) do findstr /I /C:"%%k" "%TMP%" >nul && set "dep=Yes"
    for %%k in (%KW_CFG%) do findstr /I /C:"%%k" "%TMP%" >nul && set "cfg=Yes"
    findstr /I /C:"%KW_GS%" "%TMP%" >nul && set "gs=Yes"
)

rem --- Check loadconfig section ---
dumpbin /loadconfig "%file%" >> "%TMP%" 2>> "%TMPERR%"
set "rc2=%ERRORLEVEL%"

if "%rc2%" neq "0" (
    if not defined notes (
        set "notes=Warning: no loadconfig info"
    ) else (
        set "notes=!notes!; no loadconfig info"
    )
) else (
    for %%k in (%KW_ASLR%) do findstr /I /C:"%%k" "%TMP%" >nul && set "aslr=Yes"
    for %%k in (%KW_DEP%) do findstr /I /C:"%%k" "%TMP%" >nul && set "dep=Yes"
    for %%k in (%KW_CFG%) do findstr /I /C:"%%k" "%TMP%" >nul && set "cfg=Yes"
    for %%k in (%KW_SEH%) do findstr /I /C:"%%k" "%TMP%" >nul && set "seh=Yes"
)

rem --- Append stderr output to notes if any ---
for /f "usebackq delims=" %%e in ("%TMPERR%") do (
    if defined notes (
        set "notes=!notes!; %%e"
    ) else (
        set "notes=%%e"
    )
)

set "fout=%file:"=""%"
set "nout=%notes:"=""%"
>> "%OUT%" echo "!fout!","!aslr!","!dep!","!cfg!","!seh!","!gs!","!nout!"

if exist "%TMP%" del "%TMP%" >nul 2>&1
if exist "%TMPERR%" del "%TMPERR%" >nul 2>&1
endlocal
goto :eof